//
//  MCWebViewTemplateRegistry.h
//  MCApplication
//
//  Created by Ali Lalani on 3/21/05.
//  Copyright 2005 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class MCWebViewTemplate;

@interface MCWebViewTemplateRegistry : NSObject {
	NSMutableDictionary *_extensions;
	NSMutableDictionary *_templateIdentifiers;
}
+ (MCWebViewTemplateRegistry *)defaultRegistry;

- (void)registerTemplatesAtPath:(NSString *)aPath extension:(NSString *)ext;

- (NSArray *)templatesForExtension:(NSString *)ext entityName:(NSString *)entityName;
- (NSArray *)templatesForExtension:(NSString *)ext applicableClassname:(NSString *)cname;

- (MCWebViewTemplate *)templateForExtension:(NSString *)ext entityName:(NSString *)entityName
								 identifier:(NSString *)ident;
- (MCWebViewTemplate *)templateForExtension:(NSString *)ext applicableClassname:(NSString *)cname
								 identifier:(NSString *)ident;


- (MCWebViewTemplate *)templateForIdentifier:(NSString *)ident;

- (MCWebViewTemplate *)defaultTemplateForExtension:(NSString *)ext
										entityName:(NSString *)entityName;
- (MCWebViewTemplate *)defaultTemplateForExtension:(NSString *)ext
											 model:(id)aModel;

// in the case where we don't have a default template but instead go by identifiers and extension
- (MCWebViewTemplate *)templateForExtension:(NSString *)ext identifier:(NSString *)ident;

- (void)setDefaultForTemplate:(MCWebViewTemplate *)temp;

- (void)setExtensions:(NSMutableDictionary *)ext;
- (NSMutableDictionary *)extensions;
@end
